/*
 * Decompiled with CFR 0.152.
 */
package com.example.demo.controller;

import com.example.demo.model.Country;
import com.example.demo.service.CountryService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/countries"})
public class CountryController {
    @Autowired
    private CountryService countryService;

    @GetMapping
    public List<Country> getAllCountries() {
        return this.countryService.getAllCountries();
    }

    @PostMapping(value={"/by-id"})
    public ResponseEntity<Country> getCountryById(@RequestParam(value="id") Long id) {
        Country country = this.countryService.getCountryById(id);
        if (country != null) {
            return ResponseEntity.ok((Object)country);
        }
        return ResponseEntity.notFound().build();
    }
}

